/*
 * Decompiled with CFR 0.152.
 */
package jade.core.messaging;

import jade.core.AID;
import jade.core.AgentContainer;
import jade.core.BaseService;
import jade.core.CaseInsensitiveString;
import jade.core.ContainerID;
import jade.core.Filter;
import jade.core.GenericCommand;
import jade.core.HorizontalCommand;
import jade.core.IMTPException;
import jade.core.MainContainer;
import jade.core.Node;
import jade.core.NotFoundException;
import jade.core.Profile;
import jade.core.ProfileException;
import jade.core.Service;
import jade.core.ServiceException;
import jade.core.Sink;
import jade.core.Specifier;
import jade.core.VerticalCommand;
import jade.core.messaging.GenericMessage;
import jade.core.messaging.IncomingEncodingFilter;
import jade.core.messaging.MessageManager;
import jade.core.messaging.MessagingSlice;
import jade.core.messaging.OutgoingEncodingFilter;
import jade.core.messaging.RoutingTable;
import jade.domain.FIPAAgentManagement.Envelope;
import jade.domain.FIPAAgentManagement.InternalError;
import jade.domain.FIPAAgentManagement.ReceivedObject;
import jade.lang.acl.ACLCodec;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.LEAPACLCodec;
import jade.lang.acl.StringACLCodec;
import jade.mtp.InChannel;
import jade.mtp.MTP;
import jade.mtp.MTPDescriptor;
import jade.mtp.MTPException;
import jade.mtp.TransportAddress;
import jade.security.JADESecurityException;
import jade.util.HashCache;
import jade.util.leap.ArrayList;
import jade.util.leap.HashMap;
import jade.util.leap.Iterator;
import jade.util.leap.List;
import jade.util.leap.Map;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Hashtable;

public class MessagingService
extends BaseService
implements MessageManager.Channel {
    public static final String NAME = "jade.core.messaging.Messaging";
    public static final String ENABLE_MONITOR = "jade_core_messaging_MessagingService_enablemonitor";
    public static final String MONITOR_AGENT_NAME = "messaging-monitor-%C";
    public static final String CACHE_SIZE = "jade_core_messaging_MessagingService_cachesize";
    public static final int CACHE_SIZE_DEFAULT = 100;
    public static final String ATTACH_PLATFORM_INFO = "jade_core_messaging_MessagingService_attachplatforminfo";
    public static final String PLATFORM_IDENTIFIER = "x-sender-platform-identifer";
    public static final String MTP_IDENTIFIER = "x-sender-mtp-identifer";
    private Profile myProfile;
    private boolean acceptForeignAgents = false;
    private String platformID;
    private AgentContainer myContainer;
    private final ServiceComponent localSlice = new ServiceComponent();
    private final CommandSourceSink senderSink = new CommandSourceSink();
    private final CommandTargetSink receiverSink = new CommandTargetSink();
    private Filter encOutFilter;
    private Filter encInFilter;
    private Map cachedSlices;
    private RoutingTable routes;
    private static final int EXPECTED_ACLENCODINGS_SIZE = 3;
    private final Map messageEncodings = new HashMap(3);
    private String accID;
    private MessageManager myMessageManager;
    private static final String[] OWNED_COMMANDS = new String[]{"Send-Message", "Notify-Failure", "Install-MTP", "Uninstall-MTP", "New-MTP", "Dead-MTP", "Set-Platform-Addresses"};
    private volatile int traceCnt = 0;

    public void init(AgentContainer ac, Profile p) throws ProfileException {
        super.init(ac, p);
        this.myProfile = p;
        this.myContainer = ac;
        int size = 100;
        try {
            size = Integer.parseInt(this.myProfile.getParameter(CACHE_SIZE, null));
        }
        catch (Exception e) {
            // empty catch block
        }
        this.cachedSlices = new HashCache(size);
        this.routes = new RoutingTable(this.myProfile.getBooleanProperty(ATTACH_PLATFORM_INFO, false));
        this.acceptForeignAgents = this.myProfile.getBooleanProperty("accept-foreign-agents", false);
        this.platformID = this.myContainer.getPlatformID();
        this.accID = "fipa-mts://" + this.platformID + "/acc";
        this.encOutFilter = new OutgoingEncodingFilter(this.messageEncodings, this.myContainer, this);
        this.encInFilter = new IncomingEncodingFilter(this.messageEncodings, this);
        this.myMessageManager = MessageManager.instance(p);
    }

    public void boot(Profile myProfile) throws ServiceException {
        this.myProfile = myProfile;
        try {
            StringACLCodec stringCodec = new StringACLCodec();
            this.messageEncodings.put(stringCodec.getName().toLowerCase(), stringCodec);
            LEAPACLCodec efficientCodec = new LEAPACLCodec();
            this.messageEncodings.put(efficientCodec.getName().toLowerCase(), efficientCodec);
            List l = myProfile.getSpecifiers("aclcodecs");
            Iterator codecs = l.iterator();
            while (codecs.hasNext()) {
                Specifier spec = (Specifier)codecs.next();
                String className = spec.getClassName();
                try {
                    Class<?> c = Class.forName(className);
                    ACLCodec codec = (ACLCodec)c.newInstance();
                    this.messageEncodings.put(codec.getName().toLowerCase(), codec);
                    if (!this.myLogger.isLoggable(7)) continue;
                    this.myLogger.log(7, "Installed " + codec.getName() + " ACLCodec implemented by " + className + "\n");
                }
                catch (ClassNotFoundException cnfe) {
                    throw new ACLCodec.CodecException("ERROR: The class " + className + " for the ACLCodec not found.", cnfe);
                }
                catch (InstantiationException ie) {
                    throw new ACLCodec.CodecException("The class " + className + " raised InstantiationException (see NestedException)", ie);
                }
                catch (IllegalAccessException iae) {
                    throw new ACLCodec.CodecException("The class " + className + " raised IllegalAccessException (see nested exception)", iae);
                }
            }
            l = myProfile.getSpecifiers("mtps");
            PrintWriter f = null;
            StringBuffer sb = null;
            Iterator mtps = l.iterator();
            while (mtps.hasNext()) {
                Specifier spec = (Specifier)mtps.next();
                String className = spec.getClassName();
                String addressURL = null;
                Object[] args = spec.getArgs();
                if (args != null && args.length > 0 && (addressURL = args[0].toString()).equals("")) {
                    addressURL = null;
                }
                MessagingSlice s = (MessagingSlice)this.getSlice(this.getLocalNode().getName());
                MTPDescriptor mtp = s.installMTP(addressURL, className);
                String[] mtpAddrs = mtp.getAddresses();
                if (f == null) {
                    String fileName = myProfile.getParameter("file-dir", "") + "MTPs-" + this.myContainer.getID().getName() + ".txt";
                    f = new PrintWriter(new FileWriter(fileName));
                    sb = new StringBuffer("MTP addresses:");
                }
                f.println(mtpAddrs[0]);
                sb.append("\n");
                sb.append(mtpAddrs[0]);
            }
            if (f != null) {
                this.myLogger.log(8, sb.toString());
                f.close();
            }
        }
        catch (ProfileException pe1) {
            if (this.myLogger.isLoggable(10)) {
                this.myLogger.log(10, "Error reading MTPs/Codecs");
            }
            pe1.printStackTrace();
        }
        catch (ServiceException se) {
            if (this.myLogger.isLoggable(10)) {
                this.myLogger.log(10, "Error installing local MTPs");
            }
            se.printStackTrace();
        }
        catch (ACLCodec.CodecException ce) {
            if (this.myLogger.isLoggable(10)) {
                this.myLogger.log(10, "Error installing ACL Codec");
            }
            ce.printStackTrace();
        }
        catch (MTPException me) {
            if (this.myLogger.isLoggable(10)) {
                this.myLogger.log(10, "Error installing MTP");
            }
            me.printStackTrace();
        }
        catch (IOException ioe) {
            if (this.myLogger.isLoggable(10)) {
                this.myLogger.log(10, "Error writing platform address");
            }
            ioe.printStackTrace();
        }
        catch (IMTPException imtpe) {
            imtpe.printStackTrace();
        }
    }

    public void shutdown() {
        ArrayList platformAddresses = new ArrayList();
        Iterator routeIterator = this.routes.getAddresses();
        while (routeIterator.hasNext()) {
            platformAddresses.add(routeIterator.next());
        }
        GenericCommand cmd = new GenericCommand("Uninstall-MTP", this.getName(), null);
        routeIterator = platformAddresses.iterator();
        while (routeIterator.hasNext()) {
            String route = (String)routeIterator.next();
            try {
                cmd.addParam(route);
                this.receiverSink.consume(cmd);
                cmd.removeParam(route);
                if (!this.myLogger.isLoggable(4)) continue;
                this.myLogger.log(4, "uninstalled MTP " + route);
            }
            catch (Exception e) {
                if (!this.myLogger.isLoggable(10)) continue;
                this.myLogger.log(10, "Exception uninstalling MTP " + route + ". " + e);
            }
        }
    }

    public String getName() {
        return NAME;
    }

    public Class getHorizontalInterface() {
        try {
            return Class.forName("jade.core.messaging.MessagingSlice");
        }
        catch (ClassNotFoundException cnfe) {
            return null;
        }
    }

    public Service.Slice getLocalSlice() {
        return this.localSlice;
    }

    public Filter getCommandFilter(boolean direction) {
        if (direction) {
            return this.encOutFilter;
        }
        return this.encInFilter;
    }

    public Sink getCommandSink(boolean side) {
        if (!side) {
            return this.senderSink;
        }
        return this.receiverSink;
    }

    public String[] getOwnedCommands() {
        return OWNED_COMMANDS;
    }

    void notifyLocalMTPs() {
        Iterator it = this.routes.getLocalMTPs();
        while (it.hasNext()) {
            RoutingTable.MTPInfo info = (RoutingTable.MTPInfo)it.next();
            MTPDescriptor mtp = info.getDescriptor();
            ContainerID cid = this.myContainer.getID();
            try {
                MessagingSlice mainSlice = (MessagingSlice)this.getSlice("$$$Main-Slice$$$");
                try {
                    mainSlice.newMTP(mtp, cid);
                }
                catch (IMTPException imtpe) {
                    mainSlice = (MessagingSlice)this.getFreshSlice("$$$Main-Slice$$$");
                    mainSlice.newMTP(mtp, cid);
                }
            }
            catch (Exception e) {
                this.myLogger.log(9, "Error notifying local MTP " + mtp.getName() + " to Main Container.", e);
            }
        }
    }

    public void deliverNow(GenericMessage msg, AID receiverID) {
        block14: {
            if (msg.getTraceID() != null) {
                this.myLogger.log(8, msg.getTraceID() + " - Serving message delivery");
            }
            try {
                if (!msg.hasForeignReceiver()) {
                    this.deliverInLocalPlatfrom(msg, receiverID);
                    break block14;
                }
                Iterator addresses = receiverID.getAllAddresses();
                while (addresses.hasNext()) {
                    String address = (String)addresses.next();
                    try {
                        this.forwardMessage(msg, receiverID, address);
                        return;
                    }
                    catch (MTPException mtpe) {
                        if (!this.myLogger.isLoggable(9)) continue;
                        this.myLogger.log(9, "Cannot deliver message to address: " + address + " [" + mtpe.toString() + "]. Trying the next one...");
                    }
                }
                this.notifyFailureToSender(msg, receiverID, new InternalError("No valid address contained within the AID " + receiverID.getName()));
            }
            catch (NotFoundException nfe) {
                if (msg.getTraceID() != null) {
                    this.myLogger.log(9, msg.getTraceID() + " - Receiver does not exist.", nfe);
                }
                this.notifyFailureToSender(msg, receiverID, new InternalError("Agent not found: " + nfe.getMessage()));
            }
            catch (IMTPException imtpe) {
                if (msg.getTraceID() != null) {
                    this.myLogger.log(9, msg.getTraceID() + " - Receiver unreachable.", imtpe);
                }
                this.notifyFailureToSender(msg, receiverID, new InternalError("Agent unreachable: " + imtpe.getMessage()));
            }
            catch (ServiceException se) {
                if (msg.getTraceID() != null) {
                    this.myLogger.log(9, msg.getTraceID() + " - Service error delivering message.", se);
                }
                this.notifyFailureToSender(msg, receiverID, new InternalError("Service error: " + se.getMessage()));
            }
            catch (JADESecurityException jse) {
                if (msg.getTraceID() != null) {
                    this.myLogger.log(9, msg.getTraceID() + " - Not authorized.", jse);
                }
                this.notifyFailureToSender(msg, receiverID, new InternalError("Not authorized: " + jse.getMessage()));
            }
        }
    }

    void deliverInLocalPlatfrom(GenericMessage msg, AID receiverID) throws IMTPException, ServiceException, NotFoundException, JADESecurityException {
        MainContainer impl;
        if (msg.getTraceID() != null) {
            this.myLogger.log(8, msg.getTraceID() + " - Activating local-platform delivery");
        }
        if ((impl = this.myContainer.getMain()) != null) {
            ContainerID cid;
            MessagingSlice targetSlice;
            while ((targetSlice = this.oneShotDeliver(cid = impl.getContainerID(receiverID), msg, receiverID)) == null) {
            }
            return;
        }
        MessagingSlice cachedSlice = (MessagingSlice)this.cachedSlices.get(receiverID);
        if (cachedSlice != null) {
            block10: {
                try {
                    if (msg.getTraceID() != null) {
                        this.myLogger.log(8, msg.getTraceID() + " - Delivering message to cached slice " + cachedSlice.getNode().getName());
                    }
                    cachedSlice.dispatchLocally(msg.getSender(), msg, receiverID);
                    if (msg.getTraceID() != null) {
                        this.myLogger.log(8, msg.getTraceID() + " - Delivery OK.");
                    }
                    return;
                }
                catch (IMTPException imtpe) {
                    if (msg.getTraceID() != null) {
                        this.myLogger.log(8, msg.getTraceID() + " - Cached slice for receiver " + receiverID.getName() + " unreachable.");
                    }
                }
                catch (NotFoundException nfe) {
                    if (msg.getTraceID() == null) break block10;
                    this.myLogger.log(8, msg.getTraceID() + " - Receiver " + receiverID.getName() + " not found on cached slice container.");
                }
            }
            this.cachedSlices.remove(receiverID);
        }
        this.deliverUntilOK(msg, receiverID);
    }

    private void deliverUntilOK(GenericMessage msg, AID receiverID) throws IMTPException, NotFoundException, ServiceException, JADESecurityException {
        ContainerID cid;
        MessagingSlice targetSlice;
        do {
            MessagingSlice mainSlice = (MessagingSlice)this.getSlice("$$$Main-Slice$$$");
            try {
                cid = mainSlice.getAgentLocation(receiverID);
            }
            catch (IMTPException imtpe) {
                mainSlice = (MessagingSlice)this.getFreshSlice("$$$Main-Slice$$$");
                cid = mainSlice.getAgentLocation(receiverID);
            }
        } while ((targetSlice = this.oneShotDeliver(cid, msg, receiverID)) == null);
        this.cachedSlices.put(receiverID, targetSlice);
    }

    private MessagingSlice oneShotDeliver(ContainerID cid, GenericMessage msg, AID receiverID) throws IMTPException, ServiceException, JADESecurityException {
        block13: {
            if (msg.getTraceID() != null) {
                this.myLogger.log(4, msg.getTraceID() + " - Receiver " + receiverID.getLocalName() + " lives on container " + cid.getName());
            }
            MessagingSlice targetSlice = (MessagingSlice)this.getSlice(cid.getName());
            try {
                try {
                    if (msg.getTraceID() != null) {
                        this.myLogger.log(8, msg.getTraceID() + " - Delivering message to slice " + targetSlice.getNode().getName());
                    }
                    targetSlice.dispatchLocally(msg.getSender(), msg, receiverID);
                }
                catch (IMTPException imtpe) {
                    if (msg.getTraceID() != null) {
                        this.myLogger.log(4, msg.getTraceID() + " - Messaging slice on container " + cid.getName() + " unreachable. Try to get a fresh one.");
                    }
                    targetSlice = (MessagingSlice)this.getFreshSlice(cid.getName());
                    if (msg.getTraceID() != null && targetSlice != null) {
                        this.myLogger.log(4, msg.getTraceID() + " - Fresh slice for container " + cid.getName() + " found.");
                    }
                    targetSlice.dispatchLocally(msg.getSender(), msg, receiverID);
                }
                if (msg.getTraceID() != null) {
                    this.myLogger.log(8, msg.getTraceID() + " - Delivery OK");
                }
                return targetSlice;
            }
            catch (NotFoundException nfe) {
                if (msg.getTraceID() != null) {
                    this.myLogger.log(4, msg.getTraceID() + " - Receiver " + receiverID.getLocalName() + " not found on container " + cid.getName() + ". Possibly he moved elsewhere --> Retry");
                }
            }
            catch (NullPointerException npe) {
                if (msg.getTraceID() == null) break block13;
                this.myLogger.log(4, msg.getTraceID() + " - Container " + cid.getName() + " for receiver " + receiverID.getLocalName() + " does not exist anymore. Possibly the receiver moved elsewhere --> Retry");
            }
        }
        try {
            Thread.sleep(200L);
        }
        catch (InterruptedException ie) {}
        return null;
    }

    private void forwardMessage(GenericMessage msg, AID receiver, String address) throws MTPException {
        AID aid = msg.getEnvelope().getFrom();
        if (aid == null) {
            if (this.myLogger.isLoggable(10)) {
                this.myLogger.log(10, "ERROR: null message sender. Aborting message dispatch...");
            }
            return;
        }
        if (!aid.getAllAddresses().hasNext()) {
            this.addPlatformAddresses(aid);
        }
        try {
            this.localSlice.routeOut(msg.getEnvelope(), msg.getPayload(), receiver, address);
        }
        catch (IMTPException imtpe) {
            throw new MTPException("Error during message routing", imtpe);
        }
    }

    public void notifyFailureToSender(GenericMessage msg, AID receiver, InternalError ie) {
        ACLMessage acl = msg.getACLMessage();
        if (acl != null && "true".equals(acl.getUserDefinedParameter("JADE-ignore-failure"))) {
            return;
        }
        GenericCommand cmd = new GenericCommand("Notify-Failure", NAME, null);
        cmd.addParam(msg);
        cmd.addParam(receiver);
        cmd.addParam(ie);
        try {
            this.submit(cmd);
        }
        catch (ServiceException se) {
            se.printStackTrace();
        }
    }

    private void addPlatformAddresses(AID id) {
        Iterator it = this.routes.getAddresses();
        while (it.hasNext()) {
            String addr = (String)it.next();
            id.addAddresses(addr);
        }
    }

    final boolean livesHere(AID id) {
        if (!this.acceptForeignAgents) {
            String hap = id.getHap();
            return CaseInsensitiveString.equalsIgnoreCase(hap, this.platformID);
        }
        String[] addresses = id.getAddressesArray();
        if (addresses.length == 0) {
            return true;
        }
        boolean allLocalAddresses = true;
        int i = 0;
        while (i < addresses.length) {
            if (!this.isPlatformAddress(addresses[i])) {
                allLocalAddresses = false;
                break;
            }
            ++i;
        }
        if (allLocalAddresses) {
            return true;
        }
        try {
            MainContainer impl = this.myContainer.getMain();
            if (impl != null) {
                impl.getContainerID(id);
            } else {
                MessagingSlice mainSlice = (MessagingSlice)this.getSlice("$$$Main-Slice$$$");
                try {
                    mainSlice.getAgentLocation(id);
                }
                catch (IMTPException imtpe) {
                    mainSlice = (MessagingSlice)this.getFreshSlice("$$$Main-Slice$$$");
                    mainSlice.getAgentLocation(id);
                }
            }
            return true;
        }
        catch (NotFoundException nfe) {
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    private final boolean isPlatformAddress(String addr) {
        Iterator it = this.routes.getAddresses();
        while (it.hasNext()) {
            String ad = (String)it.next();
            if (!CaseInsensitiveString.equalsIgnoreCase(ad, addr)) continue;
            return true;
        }
        return false;
    }

    protected Service.Slice getFreshSlice(String name) throws ServiceException {
        return super.getFreshSlice(name);
    }

    private void checkTracing(GenericMessage msg) {
        ACLMessage acl = msg.getACLMessage();
        if (acl != null && (this.myLogger.isLoggable(5) || "true".equals(((Hashtable)acl.getAllUserDefinedParameters()).get("JADE-trace")))) {
            msg.setTraceID(ACLMessage.getPerformative(acl.getPerformative()) + "-" + msg.getSender().getLocalName() + "-" + this.traceCnt);
            ++this.traceCnt;
        }
    }

    public String[] getMessageManagerQueueStatus() {
        MessageManager mm = MessageManager.instance(null);
        return mm.getQueueStatus();
    }

    public String[] getMessageManagerThreadPoolStatus() {
        MessageManager mm = MessageManager.instance(null);
        return mm.getThreadPoolStatus();
    }

    private class ServiceComponent
    implements Service.Slice {
        private ServiceComponent() {
        }

        public Service getService() {
            return MessagingService.this;
        }

        public Node getNode() throws ServiceException {
            try {
                return MessagingService.this.getLocalNode();
            }
            catch (IMTPException imtpe) {
                throw new ServiceException("Problem in contacting the IMTP Manager", imtpe);
            }
        }

        public VerticalCommand serve(HorizontalCommand cmd) {
            GenericCommand result = null;
            try {
                String cmdName = cmd.getName();
                Object[] params = cmd.getParams();
                if (cmdName.equals("1")) {
                    GenericCommand gCmd = new GenericCommand("Send-Message", MessagingService.NAME, null);
                    AID senderAID = (AID)params[0];
                    GenericMessage msg = (GenericMessage)params[1];
                    AID receiverID = (AID)params[2];
                    if (msg.getTraceID() != null) {
                        MessagingService.this.myLogger.log(8, "MessagingService slice received message " + MessageManager.stringify(msg) + " for receiver " + receiverID.getLocalName() + ". Trace ID = " + msg.getTraceID());
                    }
                    gCmd.addParam(senderAID);
                    gCmd.addParam(msg);
                    gCmd.addParam(receiverID);
                    result = gCmd;
                } else if (cmdName.equals("2")) {
                    Envelope env = (Envelope)params[0];
                    byte[] payload = (byte[])params[1];
                    AID receiverID = (AID)params[2];
                    String address = (String)params[3];
                    this.routeOut(env, payload, receiverID, address);
                } else if (cmdName.equals("3")) {
                    AID agentID = (AID)params[0];
                    cmd.setReturnValue(this.getAgentLocation(agentID));
                } else if (cmdName.equals("4")) {
                    GenericCommand gCmd = new GenericCommand("Install-MTP", MessagingService.NAME, null);
                    String address = (String)params[0];
                    String className = (String)params[1];
                    gCmd.addParam(address);
                    gCmd.addParam(className);
                    result = gCmd;
                } else if (cmdName.equals("5")) {
                    GenericCommand gCmd = new GenericCommand("Uninstall-MTP", MessagingService.NAME, null);
                    String address = (String)params[0];
                    gCmd.addParam(address);
                    result = gCmd;
                } else if (cmdName.equals("6")) {
                    MTPDescriptor mtp = (MTPDescriptor)params[0];
                    ContainerID cid = (ContainerID)params[1];
                    GenericCommand gCmd = new GenericCommand("New-MTP", MessagingService.NAME, null);
                    gCmd.addParam(mtp);
                    gCmd.addParam(cid);
                    result = gCmd;
                } else if (cmdName.equals("7")) {
                    MTPDescriptor mtp = (MTPDescriptor)params[0];
                    ContainerID cid = (ContainerID)params[1];
                    GenericCommand gCmd = new GenericCommand("Dead-MTP", MessagingService.NAME, null);
                    gCmd.addParam(mtp);
                    gCmd.addParam(cid);
                    result = gCmd;
                } else if (cmdName.equals("8")) {
                    MTPDescriptor mtp = (MTPDescriptor)params[0];
                    String sliceName = (String)params[1];
                    this.addRoute(mtp, sliceName);
                } else if (cmdName.equals("9")) {
                    MTPDescriptor mtp = (MTPDescriptor)params[0];
                    String sliceName = (String)params[1];
                    this.removeRoute(mtp, sliceName);
                }
            }
            catch (Throwable t) {
                cmd.setReturnValue(t);
            }
            return result;
        }

        private void routeOut(Envelope env, byte[] payload, AID receiverID, String address) throws IMTPException, MTPException {
            RoutingTable.OutPort out = MessagingService.this.routes.lookup(address);
            if (MessagingService.this.myLogger.isLoggable(5)) {
                MessagingService.this.myLogger.log(5, "Routing message to " + receiverID.getName() + " towards port " + out);
            }
            if (out == null) {
                throw new MTPException("No suitable route found for address " + address + ".");
            }
            out.route(env, payload, receiverID, address);
        }

        private ContainerID getAgentLocation(AID agentID) throws IMTPException, NotFoundException {
            MainContainer impl = MessagingService.this.myContainer.getMain();
            if (impl != null) {
                return impl.getContainerID(agentID);
            }
            return null;
        }

        private void addRoute(MTPDescriptor mtp, String sliceName) throws IMTPException, ServiceException {
            MessagingSlice slice = (MessagingSlice)MessagingService.this.getFreshSlice(sliceName);
            if (MessagingService.this.routes.addRemoteMTP(mtp, sliceName, slice)) {
                String[] pp = mtp.getSupportedProtocols();
                int i = 0;
                while (i < pp.length) {
                    if (MessagingService.this.myLogger.isLoggable(7)) {
                        MessagingService.this.myLogger.log(7, "Added Route-Via-Slice(" + sliceName + ") for protocol " + pp[i]);
                    }
                    ++i;
                }
                String[] addresses = mtp.getAddresses();
                int i2 = 0;
                while (i2 < addresses.length) {
                    MessagingService.this.myContainer.addAddressToLocalAgents(addresses[i2]);
                    ++i2;
                }
            }
        }

        private void removeRoute(MTPDescriptor mtp, String sliceName) throws IMTPException, ServiceException {
            MessagingSlice slice = (MessagingSlice)MessagingService.this.getSlice(sliceName);
            MessagingService.this.routes.removeRemoteMTP(mtp, sliceName, slice);
            String[] pp = mtp.getSupportedProtocols();
            int i = 0;
            while (i < pp.length) {
                if (MessagingService.this.myLogger.isLoggable(7)) {
                    MessagingService.this.myLogger.log(7, "Removed Route-Via-Slice(" + sliceName + ") for protocol " + pp[i]);
                }
                ++i;
            }
            String[] addresses = mtp.getAddresses();
            int i2 = 0;
            while (i2 < addresses.length) {
                MessagingService.this.myContainer.removeAddressFromLocalAgents(addresses[i2]);
                ++i2;
            }
        }
    }

    private class CommandTargetSink
    implements Sink {
        private CommandTargetSink() {
        }

        public void consume(VerticalCommand cmd) {
            try {
                String name = cmd.getName();
                if (name.equals("Send-Message")) {
                    this.handleSendMessage(cmd);
                } else if (name.equals("Install-MTP")) {
                    MTPDescriptor result = this.handleInstallMTP(cmd);
                    cmd.setReturnValue(result);
                } else if (name.equals("Uninstall-MTP")) {
                    this.handleUninstallMTP(cmd);
                } else if (name.equals("New-MTP")) {
                    this.handleNewMTP(cmd);
                } else if (name.equals("Dead-MTP")) {
                    this.handleDeadMTP(cmd);
                } else if (name.equals("Set-Platform-Addresses")) {
                    this.handleSetPlatformAddresses(cmd);
                } else if (name.equals("New-Slice")) {
                    this.handleNewSlice(cmd);
                }
            }
            catch (IMTPException imtpe) {
                cmd.setReturnValue(imtpe);
            }
            catch (NotFoundException nfe) {
                cmd.setReturnValue(nfe);
            }
            catch (ServiceException se) {
                cmd.setReturnValue(se);
            }
            catch (MTPException mtpe) {
                cmd.setReturnValue(mtpe);
            }
        }

        private void handleSendMessage(VerticalCommand cmd) throws NotFoundException {
            Object[] params = cmd.getParams();
            AID senderID = (AID)params[0];
            GenericMessage msg = (GenericMessage)params[1];
            AID receiverID = (AID)params[2];
            if (msg.getTraceID() != null) {
                MessagingService.this.myLogger.log(8, msg.getTraceID() + " - MessagingService target sink posting message to receiver " + receiverID.getLocalName());
            }
            this.postMessage(msg.getACLMessage(), receiverID);
            if (msg.getTraceID() != null) {
                MessagingService.this.myLogger.log(8, msg.getTraceID() + " - Message posted");
            }
        }

        private MTPDescriptor handleInstallMTP(VerticalCommand cmd) throws IMTPException, ServiceException, MTPException {
            Object[] params = cmd.getParams();
            String address = (String)params[0];
            String className = (String)params[1];
            return this.installMTP(address, className);
        }

        private void handleUninstallMTP(VerticalCommand cmd) throws IMTPException, ServiceException, NotFoundException, MTPException {
            Object[] params = cmd.getParams();
            String address = (String)params[0];
            this.uninstallMTP(address);
        }

        private void handleNewMTP(VerticalCommand cmd) throws IMTPException, ServiceException {
            Object[] params = cmd.getParams();
            MTPDescriptor mtp = (MTPDescriptor)params[0];
            ContainerID cid = (ContainerID)params[1];
            this.newMTP(mtp, cid);
        }

        private void handleDeadMTP(VerticalCommand cmd) throws IMTPException, ServiceException {
            Object[] params = cmd.getParams();
            MTPDescriptor mtp = (MTPDescriptor)params[0];
            ContainerID cid = (ContainerID)params[1];
            this.deadMTP(mtp, cid);
        }

        private void handleSetPlatformAddresses(VerticalCommand cmd) {
        }

        private void handleNewSlice(VerticalCommand cmd) {
            block7: {
                MainContainer impl = MessagingService.this.myContainer.getMain();
                if (impl == null) break block7;
                Object[] params = cmd.getParams();
                String newSliceName = (String)params[0];
                try {
                    MessagingSlice newSlice = (MessagingSlice)MessagingService.this.getFreshSlice(newSliceName);
                    ContainerID[] cids = impl.containerIDs();
                    int i = 0;
                    while (i < cids.length) {
                        ContainerID cid = cids[i];
                        try {
                            List mtps = impl.containerMTPs(cid);
                            Iterator it = mtps.iterator();
                            while (it.hasNext()) {
                                MTPDescriptor mtp = (MTPDescriptor)it.next();
                                newSlice.addRoute(mtp, cid.getName());
                            }
                        }
                        catch (NotFoundException nfe) {
                            nfe.printStackTrace();
                        }
                        ++i;
                    }
                }
                catch (ServiceException se) {
                    se.printStackTrace();
                }
                catch (IMTPException imtpe) {
                    imtpe.printStackTrace();
                }
            }
        }

        private void postMessage(ACLMessage msg, AID receiverID) throws NotFoundException {
            boolean found = MessagingService.this.myContainer.postMessageToLocalAgent(msg, receiverID);
            if (!found) {
                throw new NotFoundException("Messaging service slice failed to find " + receiverID);
            }
        }

        private MTPDescriptor installMTP(String address, String className) throws IMTPException, ServiceException, MTPException {
            try {
                TransportAddress ta;
                Class<?> c = Class.forName(className);
                MTP proto = (MTP)c.newInstance();
                InChannel.Dispatcher dispatcher = new InChannel.Dispatcher(){

                    public void dispatchMessage(Envelope env, byte[] payload) {
                        if (MessagingService.this.myLogger.isLoggable(5)) {
                            MessagingService.this.myLogger.log(5, "Message from remote platform received");
                        }
                        ReceivedObject[] stamps = env.getStamps();
                        int i = 0;
                        while (i < stamps.length) {
                            String id = stamps[i].getBy();
                            if (CaseInsensitiveString.equalsIgnoreCase(id, MessagingService.this.accID)) {
                                System.err.println("ERROR: Message loop detected !!!");
                                System.err.println("Route is: ");
                                int j = 0;
                                while (j < stamps.length) {
                                    System.err.println("[" + j + "]" + stamps[j].getBy());
                                    ++j;
                                }
                                System.err.println("Message dispatch aborted.");
                                return;
                            }
                            ++i;
                        }
                        ReceivedObject ro = new ReceivedObject();
                        ro.setBy(MessagingService.this.accID);
                        ro.setDate(new Date());
                        env.setReceived(ro);
                        Iterator it = env.getAllIntendedReceiver();
                        while (it.hasNext()) {
                            AID rcv = (AID)it.next();
                            GenericMessage msg = new GenericMessage(env, payload);
                            MessagingService.this.myMessageManager.deliver(msg, rcv, MessagingService.this);
                        }
                    }
                };
                if (address == null) {
                    ta = proto.activate(dispatcher, MessagingService.this.myProfile);
                    address = proto.addrToStr(ta);
                } else {
                    ta = proto.strToAddr(address);
                    proto.activate(dispatcher, ta, MessagingService.this.myProfile);
                }
                MTPDescriptor result = new MTPDescriptor(proto.getName(), className, new String[]{address}, proto.getSupportedProtocols());
                MessagingService.this.routes.addLocalMTP(address, proto, result);
                String[] pp = result.getSupportedProtocols();
                int i = 0;
                while (i < pp.length) {
                    if (MessagingService.this.myLogger.isLoggable(7)) {
                        MessagingService.this.myLogger.log(7, "Added Route-Via-MTP for protocol " + pp[i]);
                    }
                    ++i;
                }
                String[] addresses = result.getAddresses();
                int i2 = 0;
                while (i2 < addresses.length) {
                    MessagingService.this.myContainer.addAddressToLocalAgents(addresses[i2]);
                    ++i2;
                }
                GenericCommand gCmd = new GenericCommand("New-MTP", MessagingService.NAME, null);
                gCmd.addParam(result);
                gCmd.addParam(MessagingService.this.myContainer.getID());
                MessagingService.this.submit(gCmd);
                return result;
            }
            catch (ClassNotFoundException cnfe) {
                throw new MTPException("ERROR: The class " + className + " for the " + address + " MTP was not found");
            }
            catch (InstantiationException ie) {
                throw new MTPException("The class " + className + " raised InstantiationException (see nested exception)", ie);
            }
            catch (IllegalAccessException iae) {
                throw new MTPException("The class " + className + " raised IllegalAccessException (see nested exception)", iae);
            }
        }

        private void uninstallMTP(String address) throws IMTPException, ServiceException, NotFoundException, MTPException {
            MTPDescriptor desc;
            RoutingTable.MTPInfo info = MessagingService.this.routes.removeLocalMTP(address);
            if (info != null) {
                MTP proto = info.getMTP();
                TransportAddress ta = proto.strToAddr(address);
                proto.deactivate(ta);
                desc = info.getDescriptor();
                String[] addresses = desc.getAddresses();
                int i = 0;
                while (i < addresses.length) {
                    MessagingService.this.myContainer.removeAddressFromLocalAgents(addresses[i]);
                    ++i;
                }
            } else {
                throw new MTPException("No such address was found on this container: " + address);
            }
            GenericCommand gCmd = new GenericCommand("Dead-MTP", MessagingService.NAME, null);
            gCmd.addParam(desc);
            gCmd.addParam(MessagingService.this.myContainer.getID());
            MessagingService.this.submit(gCmd);
        }

        private void newMTP(MTPDescriptor mtp, ContainerID cid) throws IMTPException, ServiceException {
            MainContainer impl = MessagingService.this.myContainer.getMain();
            if (impl != null) {
                Service.Slice[] slices = MessagingService.this.getAllSlices();
                int i = 0;
                while (i < slices.length) {
                    try {
                        MessagingSlice slice = (MessagingSlice)slices[i];
                        String sliceName = slice.getNode().getName();
                        if (!sliceName.equals(cid.getName())) {
                            slice.addRoute(mtp, cid.getName());
                        }
                    }
                    catch (Throwable t) {
                        if (t instanceof IMTPException) {
                            throw (IMTPException)t;
                        }
                        if (t instanceof ServiceException) {
                            throw (ServiceException)t;
                        }
                        MessagingService.this.myLogger.log(9, "### addRoute() threw " + t + " ###");
                    }
                    ++i;
                }
                impl.newMTP(mtp, cid);
            }
        }

        private void deadMTP(MTPDescriptor mtp, ContainerID cid) throws IMTPException, ServiceException {
            MainContainer impl = MessagingService.this.myContainer.getMain();
            if (impl != null) {
                Service.Slice[] slices = MessagingService.this.getAllSlices();
                int i = 0;
                while (i < slices.length) {
                    try {
                        MessagingSlice slice = (MessagingSlice)slices[i];
                        String sliceName = slice.getNode().getName();
                        if (!sliceName.equals(cid.getName())) {
                            slice.removeRoute(mtp, cid.getName());
                        }
                    }
                    catch (Throwable t) {
                        if (t instanceof IMTPException) {
                            throw (IMTPException)t;
                        }
                        if (t instanceof ServiceException) {
                            throw (ServiceException)t;
                        }
                        MessagingService.this.myLogger.log(9, "### removeRoute() threw " + t + " ###");
                    }
                    ++i;
                }
                impl.deadMTP(mtp, cid);
            }
        }
    }

    private class CommandSourceSink
    implements Sink {
        private CommandSourceSink() {
        }

        public void consume(VerticalCommand cmd) {
            try {
                String name = cmd.getName();
                if (name.equals("Send-Message")) {
                    this.handleSendMessage(cmd);
                } else if (name.equals("Notify-Failure")) {
                    this.handleNotifyFailure(cmd);
                } else if (name.equals("Install-MTP")) {
                    MTPDescriptor result = this.handleInstallMTP(cmd);
                    cmd.setReturnValue(result);
                } else if (name.equals("Uninstall-MTP")) {
                    this.handleUninstallMTP(cmd);
                } else if (name.equals("New-MTP")) {
                    this.handleNewMTP(cmd);
                } else if (name.equals("Dead-MTP")) {
                    this.handleDeadMTP(cmd);
                } else if (name.equals("Set-Platform-Addresses")) {
                    this.handleSetPlatformAddresses(cmd);
                }
            }
            catch (IMTPException imtpe) {
                imtpe.printStackTrace();
            }
            catch (NotFoundException nfe) {
                nfe.printStackTrace();
            }
            catch (ServiceException se) {
                se.printStackTrace();
            }
            catch (MTPException mtpe) {
                mtpe.printStackTrace();
            }
            catch (Throwable t) {
                cmd.setReturnValue(t);
            }
        }

        private void handleSendMessage(VerticalCommand cmd) {
            Object[] params = cmd.getParams();
            AID sender = (AID)params[0];
            GenericMessage msg = (GenericMessage)params[1];
            AID dest = (AID)params[2];
            msg.setSenderPrincipal(cmd.getPrincipal());
            msg.setSenderCredentials(cmd.getCredentials());
            MessagingService.this.checkTracing(msg);
            if (msg.getTraceID() != null) {
                MessagingService.this.myLogger.log(8, "MessagingService source sink handling message " + MessageManager.stringify(msg) + " for receiver " + dest.getName() + ". TraceID = " + msg.getTraceID());
            }
            MessagingService.this.myMessageManager.deliver(msg, dest, MessagingService.this);
            if (msg.getTraceID() != null) {
                MessagingService.this.myLogger.log(8, msg.getTraceID() + " - Message enqueued to MessageManager.");
            }
        }

        private void handleNotifyFailure(VerticalCommand cmd) {
            Object[] params = cmd.getParams();
            GenericMessage msg = (GenericMessage)params[0];
            AID receiver = (AID)params[1];
            InternalError ie = (InternalError)params[2];
            ACLMessage aclmsg = msg.getACLMessage();
            if (aclmsg.getSender() == null || aclmsg.getSender().equals(MessagingService.this.myContainer.getAMS())) {
                return;
            }
            ACLMessage failure = aclmsg.createReply();
            failure.setPerformative(6);
            AID theAMS = MessagingService.this.myContainer.getAMS();
            failure.setSender(theAMS);
            failure.setLanguage("fipa-sl");
            String content = "( (action " + msg.getSender().toString();
            content = content + " (ACLMessage) ) (MTS-error " + receiver + " " + ie.getMessage() + ") )";
            failure.setContent(content);
            try {
                GenericCommand command = new GenericCommand("Send-Message", MessagingService.NAME, null);
                command.addParam(theAMS);
                GenericMessage gm = new GenericMessage(failure);
                gm.setAMSFailure(true);
                command.addParam(gm);
                command.addParam((AID)failure.getAllReceiver().next());
                MessagingService.this.submit(command);
            }
            catch (ServiceException se) {
                se.printStackTrace();
            }
        }

        private MTPDescriptor handleInstallMTP(VerticalCommand cmd) throws IMTPException, ServiceException, NotFoundException, MTPException {
            Object[] params = cmd.getParams();
            String address = (String)params[0];
            ContainerID cid = (ContainerID)params[1];
            String className = (String)params[2];
            MessagingSlice targetSlice = (MessagingSlice)MessagingService.this.getSlice(cid.getName());
            try {
                return targetSlice.installMTP(address, className);
            }
            catch (IMTPException imtpe) {
                targetSlice = (MessagingSlice)MessagingService.this.getFreshSlice(cid.getName());
                return targetSlice.installMTP(address, className);
            }
        }

        private void handleUninstallMTP(VerticalCommand cmd) throws IMTPException, ServiceException, NotFoundException, MTPException {
            Object[] params = cmd.getParams();
            String address = (String)params[0];
            ContainerID cid = (ContainerID)params[1];
            MessagingSlice targetSlice = (MessagingSlice)MessagingService.this.getSlice(cid.getName());
            try {
                targetSlice.uninstallMTP(address);
            }
            catch (IMTPException imtpe) {
                targetSlice = (MessagingSlice)MessagingService.this.getFreshSlice(cid.getName());
                targetSlice.uninstallMTP(address);
            }
        }

        private void handleNewMTP(VerticalCommand cmd) throws IMTPException, ServiceException {
            Object[] params = cmd.getParams();
            MTPDescriptor mtp = (MTPDescriptor)params[0];
            ContainerID cid = (ContainerID)params[1];
            MessagingSlice mainSlice = (MessagingSlice)MessagingService.this.getSlice("$$$Main-Slice$$$");
            try {
                mainSlice.newMTP(mtp, cid);
            }
            catch (IMTPException imtpe) {
                mainSlice = (MessagingSlice)MessagingService.this.getFreshSlice("$$$Main-Slice$$$");
                mainSlice.newMTP(mtp, cid);
            }
        }

        private void handleDeadMTP(VerticalCommand cmd) throws IMTPException, ServiceException {
            Object[] params = cmd.getParams();
            MTPDescriptor mtp = (MTPDescriptor)params[0];
            ContainerID cid = (ContainerID)params[1];
            MessagingSlice mainSlice = (MessagingSlice)MessagingService.this.getSlice("$$$Main-Slice$$$");
            try {
                mainSlice.deadMTP(mtp, cid);
            }
            catch (IMTPException imtpe) {
                mainSlice = (MessagingSlice)MessagingService.this.getFreshSlice("$$$Main-Slice$$$");
                mainSlice.deadMTP(mtp, cid);
            }
        }

        private void handleSetPlatformAddresses(VerticalCommand cmd) {
            Object[] params = cmd.getParams();
            AID id = (AID)params[0];
            id.clearAllAddresses();
            MessagingService.this.addPlatformAddresses(id);
        }
    }

    public static class UnknownACLEncodingException
    extends NotFoundException {
        UnknownACLEncodingException(String msg) {
            super(msg);
        }
    }
}

